<?php
require_once('Access.php');
class Podcast extends Access
{
	function __construct()
	{
		parent::__construct('podcast');


	}

	function index()
	{
		$this->session->unset_userdata('searchterm');
		$pag = $this->config->item('pagination');
		$pag['base_url'] = site_url('podcast/index');
		$pag['total_rows'] = $this->podcast_model->count_all();
		$data['items'] = $this->podcast_model->get_all($pag['per_page'],$this->uri->segment(3));
		$data['pag'] = $pag;
		$content['content'] = $this->load->view('podcast/view',$data,true);
		$this->load->view('template',$content);
	}

	function add()
	{

		$this->check_access('add');
		if ($this->input->server('REQUEST_METHOD')=='POST') {

			$name = $this->session->userdata("name");
			$file = $this->session->userdata("file");
			$tname = str_replace(".mp3", "", $name);


				$dataradio = array(

					'track_name' => $tname,
					//'track_file'=> $file_path,
					'file' => $file
				);


			if ($this->podcast_model->save($dataradio)) {
				$this->session->set_flashdata('success','Item is successfully added.');
				$push = $this->input->post('title');

				redirect('podcast');
			} else {
				$this->session->set_flashdata('error','Database error occured.Please contact your system administrator.');
			}


		}

		$content['content'] = $this->load->view('podcast/add',array(),true);
		$this->load->view('template',$content);

}

	function upload_files(){
		$name_f = $this->session->userdata("name");
		$file_f = $this->session->userdata("file");


		 $files = $_FILES;

		 $cpt = count($_FILES['userfile']['name']);


				for ($i = 0; $i < $cpt; $i++)
				{

				$config['upload_path']   = './music/';
				$config['allowed_types'] = 'mp3';
				$config['overwrite'] = TRUE;
				$config['remove_spaces'] = TRUE;
				$config['make_unique_filename'] = true;
				$config['encrypt_name'] = FALSE;
				$new_name = $_FILES["file"]['name'];//time();//.$_FILES["file"]['name'];
			  $config['file_name'] = $new_name;


				$this->load->library('upload',$config);
				$this->upload->initialize($config);

						$_FILES['userfile']['name']= $files['userfile']['name'][$i];
						$_FILES['userfile']['type']= $files['userfile']['type'][$i];
						$_FILES['userfile']['tmp_name']= $files['userfile']['tmp_name'][$i];
						$_FILES['userfile']['error']= $files['userfile']['error'][$i];
						$_FILES['userfile']['size']= $files['userfile']['size'][$i];

						$this->upload->initialize($config);

						$this->upload->do_upload();

						$file_name=$files['userfile']['name'][$i];
						$tname = str_replace(".mp3", "", $file_name);
						$basename = $this->upload->data('file_name');

						$this->session->set_userdata("name",$file_name);
						$this->session->set_userdata("file",$basename);


				}

	}

	function deletez(){

		$token=$this->input->post('file');
		$file_path = 'music/'.$token;

		$imsess = $this->session->userdata("trk");

		$icv = count($imsess);

		foreach($imsess as $rs => $key){

				   if ($token == $key){

						unset($imsess[$rs]);

						$this->session->unset_userdata('trk');
						$this->session->set_userdata("trk",$imsess);
					}
				}

		$query=$this->db->get_where('podcast',array('file'=>$token));
		if($query->num_rows()>0){
		$data=$query->row();


         unlink($file_path);
			}
		$this->db->delete('podcast',array('file'=>$token));
		echo json_encode(array('deleted'=>true));
		}



	function delete($item_id=0)
	{
		$this->check_access('delete');

		$imgs = $this->podcast_model->get_info($item_id)->file;

		unlink('./music/'.$imgs);


		if ($this->podcast_model->delete($item_id)) {
			$this->session->set_flashdata('success','The item is successfully deleted.');
		} else {
			$this->session->set_flashdata('error','Database error occured.Please contact your system administrator.');
		}
		redirect(site_url('podcast'));
	}

}
?>
